<?php if ($users): ?>

    <div class="row row-cols-lg-3 row-cols-xxl-4">

        <?php foreach ($users as $user): ?>

            <?php

            $name_tipo = '';

            switch ($user->tipo) {

                case 'a':
                    $class_tipo = 'success';
                    $name_tipo = 'Administrador';
                    break;
                case 'f':
                    $class_tipo = 'warning';
                    $name_tipo = 'Fornecedor';
                    break;
                case 'e':
                    $class_tipo = 'light';
                    $name_tipo = 'Estoquista';
                    break;
                    // Caso seja 'u' será considerado desativado.
                default:
                    $name_tipo = 'Desativado';
                    break;
            }

            ?>

            <div class="col-md mb-4">

                <ul class="list-group">

                    <li class="list-group-item list-group-item-dark">
                        <?= $name_tipo; ?>

                        <span class="float-end">

                            <?= anchor('a/user/edit/' . $user->idusuario, '<i class="bi bi-pencil text-succes"></i>', [
                                'class' => 'me-lg-3 btn btn-sm btn-success',
                                'data-bs-toggle' => 'tooltip',
                                'title' => 'Editar usuário',
                            ]); ?>

                            <?= anchor('a/user/delete/' . $user->idusuario, '<i class="bi bi-trash text-dange"></i>', [
                                'class' => 'btn btn-sm btn-danger',
                                'data-bs-toggle' => 'tooltip',
                                'title' => 'Excluir usuário',
                                'onclick' => "{
                                    return (prompt('Digite o número " . $user->idusuario . " para excluir o usuário.') == " . $user->idusuario . ");
                                    
                                }"

                            ]); ?>

                        </span>

                    </li>

                    <li class="list-group-item" data-bs-toggle="tooltip" title="Nome do usuário"><?= $user->nome; ?></li>

                    <li class="list-group-item" data-bs-toggle="tooltip" title="Login"><?= $user->login; ?></li>

                    <li class="list-group-item" data-bs-toggle="tooltip" title="Email"><?= $user->email; ?></li>

                    <li class="list-group-item" data-bs-toggle="tooltip" title="Telefone"><?= $user->telefone; ?></li>

                    <li class="list-group-item" data-bs-toggle="tooltip" title="Último acesso">

                        <?=

                        ($user->ultimo_acesso != '0000-00-00 00:00:00')

                            ?

                            date_format(date_create($user->ultimo_acesso), 'd/m/Y \à\s H:i:s')

                            :

                            'Nunca acessou';

                        ?>

                    </li>

                </ul>

            </div>

        <?php endforeach; ?>

    </div>

<?php else: ?>

    <h1 class="text-info text-center">Sem resultados</h1>

<?php endif; ?>