<div class="container-lg col-lg-4" data-bs-theme="dark">

    <?= form_open(
        'a/user/save',
        [
            'class' => 'form-control bg-body-secondary',
            'autocomplete' => 'off',
            'spellcheck' => 'false'
        ]
    ); ?>

    <div class="my-3">

        <?= view('button_go_back', [

            'page_back' => base_url('a/user'),

        ]); ?>

    </div>

    <div class="my-3">

        <label for="name" class="form-label">Nome</label>

        <input type="text" name="nome" id="name" class="form-control" value="<?= (isset($user)) ? $user->nome : '' ?>" autofocus required minlength="3" spellcheck="false">

    </div>

    <div class="my-3">

        <label for="login" class="form-label">Login</label>

        <input type="text" name="login" id="login" class="form-control" value="<?= (isset($user)) ? $user->login : '' ?>" required minlength="3" spellcheck="false">

    </div>

    <div class="my-3">

        <label
            for="password"
            class="form-label">
            Senha<?= (isset($user)) ? '<br><b class="text-info" style="font-size:0.9rem;">*Se não for mudar a senha, deixe o campo em branco.</b>' : ''; ?>
        </label>

        <input type="password" name="senha" id="password" class="form-control" <?= (isset($user)) ? '' : 'required'; ?> minlength="4">

    </div>

    <div class="my-3">

        <label for="email" class="form-label">Email</label>

        <input type="email" name="email" id="email" class="form-control" value="<?= (isset($user)) ? $user->email : '' ?>">

    </div>

    <div class="my-3">

        <label for="telefone" class="form-label">Telefone</label>

        <input type="text" name="telefone" id="telefone" class="form-control" value="<?= (isset($user)) ? $user->telefone : '' ?>">

    </div>



    <?php

    $checked = 'checked';
    $tipo_a = '';
    $tipo_e = '';
    $tipo_f = '';
    $tipo_u = $checked;

    if (isset($user)) {

        switch ($user->tipo) {
            case 'a':
                $tipo_a = $checked;
                $tipo_u = '';
                break;
            case 'e':
                $tipo_e = $checked;
                $tipo_u = '';
                break;
            case 'f':
                $tipo_f = $checked;
                $tipo_u = '';
                break;
            default:
                $tipo_u = $checked;
                break;
        }
    }

    ?>


    Status

    <div class="d-flex border border-1 rounded-2 p-2 my-3 justify-content-around">

        <div class="form-check">

            <input
                class="form-check-input"
                type="radio"
                name="tipo"
                value="a"
                id="tipo_a"
                <?= $tipo_a ?> />

            <label class="form-check-label fw-bold" for="tipo_a" data-bs-toggle="tooltip" title="Administrador">

                A

            </label>

        </div>

        <div class="form-check">

            <input
                class="form-check-input"
                type="radio"
                name="tipo"
                value="e"
                id="tipo_e"
                <?= $tipo_e ?> />

            <label class="form-check-label fw-bold" for="tipo_e" data-bs-toggle="tooltip" title="Estoquista">

                E

            </label>

        </div>

        <div class="form-check">

            <input
                class="form-check-input"
                type="radio"
                name="tipo"
                value="f"
                id="tipo_f"
                <?= $tipo_f ?> />

            <label class="form-check-label fw-bold" for="tipo_f" data-bs-toggle="tooltip" title="Fornecedor">

                F

            </label>

        </div>

        <div class="form-check">

            <input
                class="form-check-input"
                type="radio"
                name="tipo"
                value="u"
                id="tipo_u"
                <?= $tipo_u ?> />

            <label class="form-check-label fw-bold" for="tipo_u" data-bs-toggle="tooltip" title="Desativado">

                D

            </label>

        </div>

    </div>

    <input type="hidden" name="idusuario" value="<?= (isset($user)) ? $user->idusuario : '' ?>">


    <div class="my-3">

        <button type="submit" class="btn btn-sm btn-success"><i class="bi bi-save"></i></button>

    </div>

    <?= form_close(); ?>

</div>