<?php if ($order): ?>
    <div class="row row-cols-md-1 row-cols-lg- row-cols-xxl-">

        <div class="col">

            <table class="table wtable-sm wtable-striped table-bordered table-hover">

                <thead class="table-secondary">

                    <tr>

                        <th scope="col" class="text-center">Código</th>

                        <th scope="col" class="text-center">Descrição</th>

                        <th scope="col" class="text-center">Referência</th>

                        <th scope="col" class="text-center">Valor unitário</th>

                        <th scope="col" class="text-center">Quantidade</th>

                        <th class="text-center">Subtotal</th>

                    </tr>

                </thead>

                <tbody>

                    <?php

                    $total = 0;

                    foreach ($order as $product): ?>

                        <tr class="w-mark" style="cursor:pointer;">

                            <td class=" text-end pe-2"><?= $product->codigo ?></td>

                            <td><?= $product->descricao ?></td>

                            <td><?= $product->referencia ?></td>

                            <td class="text-end">

                                R$ <?= number_format($product->valor, 2, ',', '.') ?>

                            </td>

                            <td class="text-end pe-3" style="max-width: 1rem;">

                                <?= ($product->quantidade < 10) ? '&nbsp;&nbsp;' : '' ?><?= $product->quantidade ?>

                            </td>

                            <td class="text-end">

                                <?php

                                $sub = ($product->valor * $product->quantidade);

                                $total += $sub;

                                ?>

                                R$ <?= number_format($sub, 2, ',', '.') ?>

                            </td>

                        </tr>

                    <?php endforeach; ?>

                </tbody>

            </table>

        </div>

    </div>

    <script>
        document.querySelector('.total').innerText = 'Total R$ <?= number_format($total, 2, ',', '.') ?>';
    </script>

<?php endif; ?>