<div class="row row-cols-md-1 row-cols-lg- row-cols-xxl-">

    <div class="col">

        <table class="table wtable-sm wtable-striped table-bordered table-hover">

            <thead class="table-secondary">

                <tr>

                    <th scope="col" class="text-center">Código</th>

                    <th scope="col" class="text-center">Descrição</th>

                    <th scope="col" class="text-center">Referência</th>

                    <th
                        scope="col"
                        class="text-center">
                        <span class="d-lg-none">Qtd</span>
                        <span class="d-none d-lg-inline">Quantidade</span>
                    </th>

                    <th scope="col" class="text-center">Valores</th>

                </tr>

            </thead>

            <tbody>

                <?php

                foreach ($products as $product): ?>

                    <tr>

                        <td class="text-end pe-lg-3"><?= $product->codigo ?></td>

                        <td><?= $product->descricao ?></td>

                        <td class="ps-lg-3"><?= $product->referencia ?></td>

                        <td class="text-center" style="max-width: 1rem;">

                            <?= ($product->quantidade < 10) ? '&nbsp;&nbsp;' : '' ?><?= $product->quantidade ?>

                        </td>

                        <?php
                        /**
                         * A classe $class_is_value adiciona uma cor onde existe valor.
                         * A classe $authorization impede que novos valores sejam adicioandos após finalização da cotação.
                         * 
                         */
                        $class_is_value = ($product->valor > 0) ? 'text-warning' : 'text-secondary';

                        $authorization = ($product->concluido == 's') ? '-' : ' ';
                        ?>

                        <td
                            class="pe-lg-3 text-end">
                            <?php if ($product->obs): ?>
                                <i
                                    class="bi bi-chat-right-dots text-info"
                                    data-bs-toggle="tooltip"
                                    data-bs-html="true"
                                    title="<?= $product->obs ?>"></i>

                            <?php endif; ?>

                            <span class="<?= $authorization . $class_is_value ?>">R$</span><span
                                class="add-value-supplier<?= $authorization . $class_is_value ?>"
                                id="<?= $product->idproduto ?>"
                                obs="<?= $product->obs ?>"
                                td="<?= $product->codigo ?>&<?= $product->descricao ?>&<?= $product->referencia ?>&<?= $product->quantidade ?>"
                                style="cursor: pointer<?= $authorization ?>;"><?=
                                                                                ($product->valor) ?
                                                                                    number_format($product->valor, 2, ',', '.') :
                                                                                    '0,00';
                                                                                ?>
                            </span>

                        </td>

                    </tr>

                <?php endforeach; ?>

            </tbody>

        </table>

    </div>

    <div class="col">

        <?= $pager->links(); ?>

    </div>

</div>