<!-- Button trigger modal -->
<button type="button" class="show-modal-supplier d-none" data-bs-toggle="modal" data-bs-target="#productModal">
    Launch demo modal
</button>

<!-- Modal -->
<div class="modal fade" id="productModal" tabindex="-1" aria-labelledby="productModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content w-7">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="productModalLabel">Adicionar valor</h1>

                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <table class="table table-sm table-bordered" style="font-size: 0.7rem;">
                    <thead>
                        <tr class="text-center">
                            <th>Código</th>
                            <th>Descrição</th>
                            <th>Referência</th>
                            <th>Qtd</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="table-modal"></tr>
                    </tbody>
                </table>
                <?= form_open(
                    'f/quot/add_value_obs' . '?page=' . (($_GET['page']) ?? 1),
                    [
                        'class' => 'form-control bg-body-secondary form-value-supplier',
                        'autocomplete' => 'off'
                    ]
                );
                ?>

                <div class="mb-5">&nbsp;
                    <br>
                    <input
                        class="form-control float-end w-50 input-value price text-end"
                        type="text"
                        name="value_product"
                        id="value_product"
                        required
                        onkeyup="maskMoney()">

                    <label class="form-label float-end pe-2 mt-2" for="value_product">R$</label>
                </div>
                <div class="my-3 pt-2 border-1 border-top">
                    <label class="form-label" for="obs">Observação</label>
                    <input class="form-control" type="text" name="obs" id="obs" rows="2">
                </div>
                <input class="input-hidden-id-store" type="hidden" name="id_store" value="<?= $id_store ?>">
                <input class="input-hidden-id-quot" type="hidden" name="id_quot" value="<?= $id_quot ?>">
                <input class="input-hidden-id-product-supplier" type="hidden" name="id_product">

                <input class="submit d-none" type="submit" value="">

                <?= form_close(); ?>

            </div>
            <div class="py-2 ps-3 border-1 border-top text-cente">
                <p> Tecle <b class="text-danger">Tab</b> para mudar de campo.</p>
                <p>Tecle <b class="text-danger">Enter</b> para salvar, <b class="text-danger">Esc</b> para sair.</p>
                <p>Para remover um valor inserido equivocadamente, deixe o campo preenchido com apenas o número
                    <b class="text-danger">0</b>
                    e tecle <b class="text-danger">Enter</b>.
                </p>
                <p>
                    Se você não tiver o produto (produto em falta), digite o número
                    <b class="text-danger">0</b> e tecle <b class="text-danger">Enter</b>
                    para ir ao próximo produto.
                </p>
            </div>
        </div>
    </div>
</div>

<script>
    function maskMoney() {

        let valor = $('.price').val();

        let numbers = valor.replace(/[^\d]+/gi, '');

        numbers = numbers.slice(0, 8);

        let cents = numbers.slice(numbers.length - 2, numbers.length);

        let hundred = numbers ? numbers.slice((numbers.length < 5 ? 0 : numbers.length - 5), (numbers.length - 2)) + ',' : '';

        let mine = numbers.length > 5 ? numbers.slice((numbers.length < 5 ? numbers.length - 5 : 0), numbers.length - 5) + '.' : '';

        let coin = mine + hundred + cents;

        $('.price').val(coin)

    }
</script>