<?php if ($orders): ?>

    <div class="mb-2 text-center border-bottom">

        <span>Pedidos</span>

    </div>

    <div class="row row-cols-md-3 row-cols-lg-4 row-cols-xxl-5">

        <?php foreach ($orders as $order): ?>

            <div class="col-lg mb-4">

                <?= anchor(
                    'f/order/details/' . $order->idcotacao . '/' . $order->idloja,
                    '<ul class="list-group">
                        
                        <li class="list-group-item list-group-item-success">Pedidos da cotação COT-' . $order->idcotacao . '</li>

                        <li class="list-group-item list-group-item-success">' .
                        date_format(date_create($order->c_referencia), "d/m/Y H:i:s") .
                        '</li>

                    </ul>'
                ); ?>

            </div>

        <?php endforeach; ?>

    </div>

<?php else: ?>

    <div class="mb-2 text-center">

        <span class="p-1 rounded-1 text-bg-danger blink">Não há pedidos.</span>

    </div>

<?php endif; ?>

<script>
    let blinks = document.querySelectorAll('.blink');

    setTimeout(() => {

        for (let blink of blinks) {

            blink.classList.remove('blink');

        }

    }, 3000);
</script>