<?php

/**
 * Complemento da tabela de cotação, no arquivo home_product_table.
 * 
 * Preenche o header da tabela com o nome dos participantes da cotação,
 * 
 * e o body da tabela com os produtos e valores de cada participante.
 */

function organizeParticipants($suppliers, $participants, $values, $product, $id_store)
{
    // Recebe todos os resultados.

    $tag_participant = '';

    foreach ($suppliers as $supplier) {

        foreach ($participants as $participant) {

            $isset_result = 0;

            if ($supplier->idusuario == $participant->usuario) { // Verifica se o fornecedor é participante da cotação.

                if ($product) { // veirfica se a função está preenchendo header ou o body da tabela. verdadeiro para body.

                    foreach ($values as $value) {

                        if ($value->idproduto == $product->idproduto) { // Verifica se o valor é refernte ao produto.

                            if (($value->idusuario == $supplier->idusuario)) { // Verifica se o valor é referente ao fornecedor.

                                $isset_result++;

                                // Verifica se tem mensagem de observação do participante.

                                $message = ($value->obs) ?
                                    '<i 
                                        class="bi bi-chat-right-dots text-info blink"
                                        data-bs-toggle="tooltip"
                                        data-bs-html="true"
                                        title="<b>' . $supplier->nome . ':</b><br>' . $value->obs .
                                    '" style="font-size:0.8rem"></i>' : '';

                                // Prepara o link para selecionar o valor do participante como vencedor.

                                $class = '';
                                $class_link_value = '';
                                $title = '<b class="">' . $supplier->nome . '</b><br>Selecionar valor';
                                $action = 'select_value';

                                /**
                                 * Verifica se o participante é vencedor.
                                 * Caso verdadeiro, prepara o link para remover o vencedor.
                                 */

                                if ($product->vencedor == $supplier->idusuario) {

                                    $class = 'bg-success';
                                    $title = '<b class="">' . $supplier->nome . '</b><br>Remover vencedor';
                                    $action = 'remove_value';
                                }

                                /**
                                 * Verifica se exitem valores iguais e adiciona cor preta no texto.
                                 */

                                if ($product->vencedor == -10) {

                                    $class_link_value = '- text-black equal';
                                }

                                $tag_participant .=

                                    '<td class="participants d-none text-end ' .

                                    $class .

                                    '" style="font-size:0.8rem" id="' .
                                    $product->idproduto . $supplier->idusuario .
                                    '">' .
                                    $message .
                                    ' R$ ' .
                                    anchor(
                                        'a/quot/' .
                                            $action .
                                            '/' .
                                            $product->idproduto .
                                            '/' .
                                            $supplier->idusuario .
                                            '/' .
                                            $product->cotacao_idcotacao .
                                            '/' .
                                            $id_store .
                                            '?page=' .
                                            ($_GET['page'] ?? 1),
                                        number_format($value->valor, 2, ',', '.'),

                                        [
                                            'class' => 'text-white' . $class_link_value,
                                            'data-bs-toggle' => 'tooltip',
                                            'data-bs-html' => 'true',
                                            'title' => $title,
                                            'id' => $value->valor,

                                        ]
                                    ) . '
                                    
                                    </td>';

                                break;
                            }
                        }
                    }

                    /**
                     * Se exitir valores, mas não exitir valor do fornecedor para o produto,
                     * adiciona uma célula (table data) vazia na linha.
                     * 
                     */

                    if (!$isset_result) {

                        $tag_participant .= '<td class="participants d-none text-end"></td>';

                        break;
                    }
                } else { // Preenche o cabeçalho (table header), com o nome dos participantes.

                    $staus = ($participant->concluido === 's') ?
                        '<i class="bi bi-check text-primary" data-bs-toggle="tooltip" title="Concluído"></i>' : '';

                    $tag_participant .=
                        '<th 
                        scope="col" 
                        class="participants text-center d-none" 
                        style="font-size:0.8rem;">
                        <div>
                            <span class="d-xxl-none" data-bs-toggle="tooltip" title="' . $supplier->nome . '" >' .
                            substr($supplier->nome, 0, 6) .
                            '</span><span class="d-none d-xxl-inline">' . $supplier->nome . '</span>' . $staus .
                            '
                        </div>
                        <center>
                        <div 
                            class="progress rounded-0"
                            style="width:4rem;"
                            role="progressbar"
                            aria-label="Progress"
                            aria-valuenow="0"
                            aria-valuemin="0"
                            aria-valuemax="100"
                            
                            >
                            <div 
                                class="progress-bar progress-bar-animated bg-success"
                                data-bs-toggle="tooltip"
                                data-bs-html="true"
                                title=""
                                id="' . $supplier->idusuario . '"
                                ></div>
                        </div>
                        </center>
                        </th>';

                    break;
                }
            }
        }
    }

    return $tag_participant;
}
