<?php

/**
 *  A variável $show_winners verifica o status da cotação: Se diferente de Aberto,
 *  libera a visualização dos participantes e seus respectivos valores, assim como os vencedores.
 *  Por default o sistema estará mostrando, aguardando a decisão do administrador.
 *  Obs.: Verificar ativação da função com o administrador.
 *  $show_winners = ($status_quot != 'a');
 */

$show_winners = (true);

?>

<div class="row row-cols-md-1 row-cols-lg- row-cols-xxl-">

    <div class="col">

        <table
            class="table wtable-sm wtable-striped table-bordered table-hover"
            id="<?= base_url('a/quot/progress_by_participant&' . $id_quot); ?>">

            <thead class="table-secondary">

                <tr>

                    <th scope="col" class="priority text-center">Código</th>

                    <th scope="col" class="text-center">
                        Descrição

                        <?php

                        /**
                         * Função que verificaq se os participantes finalizaram, libera o botão "Selecionar menores valores".
                         * Por default o botão está liberado, verificar com o administrador.
                         * quot_finished($participants)
                         */

                        if (true):

                        ?>

                            <?= anchor(
                                'a/quot/select_lowest_price/' .
                                    $id_quot .
                                    '/' .
                                    $id_store . $link_page,
                                '<i class="bi bi-cash-coin"></i>',
                                [
                                    'class' => 'btn btn-sm btn-success float-end participants d-none',
                                    'data-bs-toggle' => 'tooltip',
                                    'title' => 'Selecionar menores valores',
                                ]
                            ) ?>

                        <?php endif; ?>

                    </th>

                    <th scope="col" class="priority text-center">Curva</th>

                    <th scope="col" class="priority text-center">Referência</th>

                    <th scope="col" class="priority text-center" data-bs-toggle="tooltip" title="Máximo">Máx</th>

                    <th scope="col" class="priority text-center">Custo</th>

                    <th
                        scope="col"
                        class="priority text-center"
                        data-bs-toggle="tooltip"
                        title="Quantidade">
                        <span style="transform-origin: bottom center;">Qtd</span>
                    </th>

                    <th scope="col" class="priority text-center" data-bs-toggle="tooltip" title="Unidade">Uni</th>

                    <?php if ($show_winners): ?>

                        <th scope="col" class="priority text-center">Vencedores</th>

                    <?php endif; ?>

                    <?php if ($show_winners): ?>

                        <?php

                        /**
                         * Preenche a header da tabela com o nome dos participantes.
                         */

                        if ($participants):

                        ?>

                            <?= organizeParticipants($suppliers, $participants, $values, false, $id_store) ?>

                        <?php else: ?>

                            <th scope="col" class="participants d-none">Sem participantes</th>

                        <?php endif; ?>

                    <?php else: ?>

                        <th scope="col" class="participants d-none">Aguardando o fechamento da cotação...</th>

                    <?php endif; ?>

                </tr>

            </thead>

            <tbody>

                <?php

                foreach ($products as $product): ?>

                    <tr

                        style="font-size:0.8rem"
                        data-bs-toggle="tooltip"
                        data-bs-html="true"
                        data-bs-placement="bottom"
                        <?= ($product->vencedor == -10) ?
                            ' class="table-warning equal-values" title="<b>Linha com valores iguais</b>"' :
                            ''
                        ?>>

                        <td class="priority text-end pe-2">

                            <?= $product->codigo ?>

                        </td>

                        <?php

                        $class_product_descripton = '';
                        $class_product_link_disabled = '';
                        $action_product_status = -$product->quantidade;
                        $btn_product_title = 'Pausar produto';
                        $btn_product_name = '<i class="bi bi-pause-circle"></i>';
                        $qtd_value_edited = $product->quantidade;

                        $search = '-';

                        /**
                         * Verifica se o produto está desativado.
                         * Verdadeiro se receber um valor negativo.
                         * Remove o sinal negativo para o valor real ser mostrado na célula "Quantidade".
                         * Adiciona o nome do produto em vermelho.
                         * Se a quantida de for 0, desabilita o botão de abilitar o produto.
                         * E variável $action_product_status retorna para o link a ação de edição: "abilitar", "desabilitar",
                         */

                        if ($product->quantidade <= (int)0) {

                            $class_product_descripton = 'text-danger';

                            $class_product_link_disabled = ($product->quantidade === '0') ? 'disabled' : '';

                            $qtd_value_edited = str_replace('-', '', $product->quantidade);

                            $btn_product_name = '<i class="bi bi-play-circle"></i>';

                            $btn_product_title = 'Ativar produto';

                            $action_product_status = $qtd_value_edited;
                        }

                        // Calcula o estoque.

                        $stock = ((int)$product->min - $qtd_value_edited);

                        $stock = ($stock > 0) ? $stock : 0;

                        ?>

                        <td>

                            <span
                                class="<?= $class_product_descripton ?>"
                                data-bs-toggle="tooltip"
                                data-bs-html="true"
                                title='<b class="text-start text-succes" style="text-align: start!important;">
                                <span class="text-success">Aplicação:</span><br>
                                <?= str_replace('/', '<br>', $product->aplicacao); ?>
                                <br><span class="text-success">Máximo:</span> <?= (int)$product->min; ?>
                                <br><span class="text-success">Custo:</span> R$ <?= $product->custo; ?>
                                <br><span class="text-success">Estoque:</span> <?= $stock; ?></b>'>
                                <?= $product->descricao ?>
                            </span>

                            <i
                                class="bi bi-info-circle float-end me-3 text-info participants d-none"
                                data-bs-toggle="tooltip"
                                data-bs-html="true"
                                data-bs-placement="right"
                                title='
                                <b class="text-start text-succes" style="text-align: start!important;">
                                <span class="text-success">Código:</span> <?= $product->codigo; ?>
                                <br><span class="text-success">Referência:</span> <?= $product->referencia; ?>
                                <br><span class="text-success">Máximo:</span> <?= (int)$product->min; ?>
                                <br><span class="text-success">Custo:</span> R$ <?= $product->custo; ?>
                                <br><span class="text-success">Quantidade:</span> <?= $product->quantidade; ?>
                                <br><span class="text-success">Unidade:</span> <?= $product->uni; ?>
                                <br><span class="text-success">Estoque:</span> <?= $stock; ?></b>'>
                            </i>

                            <?= anchor(
                                'a/quot/change_status_product/' .
                                    $action_product_status .
                                    '/' .
                                    $product->idproduto .
                                    '/' .
                                    $id_quot .
                                    '/' .
                                    $id_store .
                                    $link_page,
                                $btn_product_name,
                                [
                                    'class' => 'btn btn-sm btn-success priority float-end me-3 ' .
                                        $class_product_link_disabled,
                                    'data-bs-toggle' => 'tooltip',
                                    'title' => $btn_product_title,
                                ]
                            )
                            ?>

                        </td>

                        <td class="priority text-center"><?= $product->curva ?></td>

                        <td class="priority"><?= $product->referencia ?></td>

                        <td class="priority pe-3 text-end"><?= (int)$product->min ?></td>

                        <td class="priority pe-2 text-end">R$ <?= number_format($product->custo, 2, ',', '.') ?></td>

                        <td class="priority text-center" style="max-width: 1rem;">

                            <span
                                class="btn btn-sm btn-success edit-qtd"
                                id="<?= $product->idproduto ?>"
                                data-bs-toggle="tooltip"
                                title="Mudar a quantidade">

                                <?= ($qtd_value_edited < 10) ? '&nbsp;&nbsp;' : '' ?><?= $qtd_value_edited ?>

                            </span>

                        </td>

                        <td class="priority text-center"><?= $product->uni ?></td>

                        <?php

                        /**
                         * Preenche a coluna vencedores.
                         */

                        if ($show_winners): ?>

                            <?php $isset_result = 0 ?>

                            <?php foreach ($suppliers as $supplier): ?>

                                <?php if ($supplier->idusuario == $product->vencedor): ?>

                                    <td class="priority">

                                        <span class="float-start"><?= $supplier->nome ?></span>

                                        <?php foreach ($values as $value): ?>

                                            <?php if (($value->idusuario == $supplier->idusuario) && ($value->idproduto == $product->idproduto)): ?>

                                                <span class="float-end">

                                                    R$ <?= number_format($value->valor, 2, ',', '.') ?>

                                                </span>

                                                <?php break; ?>

                                            <?php endif; ?>

                                        <?php endforeach; ?>

                                    </td>

                                    <?php $isset_result++ ?>

                                <?php endif; ?>

                            <?php endforeach; ?>

                            <?php

                            /**
                             * Se não tiver resultado, adiciona uma célula vazia.
                             */

                            if (!$isset_result):

                            ?>

                                <td class="priority"></td>

                            <?php endif; ?>

                        <?php endif; ?>

                        <?php

                        /**
                         * Preenche o corpo da tabela com os valores dos participantes.
                         */

                        if ($show_winners):

                            if ($participants): ?>

                                <?= organizeParticipants($suppliers, $participants, $values, $product, $id_store) ?>

                            <?php else: ?>

                                <td class="participants d-none"></td>

                            <?php endif; ?>

                        <?php else: ?>

                            <td class="participants d-none"></td>

                        <?php endif; ?>

                    </tr>

                <?php endforeach; ?>

            </tbody>

        </table>

    </div>

    <div class="col">

        <?= $pager->links(); ?>

    </div>

</div>