<?php

namespace App\Models;

use CodeIgniter\Model;

class UserModel extends Model
{

    protected $table      = 'usuario';
    protected $primaryKey = 'idusuario';

    protected $useAutoIncrement = true;

    protected $returnType     = 'object';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['nome', 'login', 'senha', 'email', 'telefone', 'tipo', 'ultimo_acesso'];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    protected $db, $sql;

    public function signIn($login, $password)
    {

        $this->db = \Config\Database::connect();

        $this->sql = 'SELECT idusuario, nome, tipo FROM usuario WHERE BINARY login = ? AND senha = ? AND tipo != "u"';

        $result = $this->db->query($this->sql, [$login, $password]);

        return $result->getResultObject();
    }
}
