<?php

namespace App\Models;

use CodeIgniter\Model;

class ProductModel extends Model
{

    protected $table      = 'produto';
    protected $primaryKey = 'idproduto';

    protected $useAutoIncrement = true;

    protected $returnType     = 'object';
    protected $useSoftDeletes = false;

    protected $allowedFields = [
        'codigo',
        'descricao',
        'min',
        'custo',
        'referencia',
        'quantidade',
        'uni',
        'aplicacao',
        'vencedor',
        'cotacao_idcotacao'
    ];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    protected $db, $sql;

    public function createProduct($id_quot)
    {

        $this->db = \Config\Database::connect();

        if ($_FILES['quot']['size'] >= 0) {

            $arquivo = fopen($_FILES['quot']['tmp_name'], "r");

            $header = fgetcsv($arquivo, 0, ",");

            while ($linha = fgetcsv($arquivo, 0, "?")) {

                $celula = explode(';', $linha[0]);

                $codigo = ltrim(mb_convert_encoding(trim($celula[0]), "UTF-8"), "?");
                $descricao = ltrim(mb_convert_encoding(trim($celula[1]), "UTF-8"), "?");
                $curva = ltrim(mb_convert_encoding(trim($celula[2]), "UTF-8"), "?");
                $min = ltrim(mb_convert_encoding(strtr(trim($celula[3]), ",", "."), "UTF-8"), "?");
                $custo = ltrim(mb_convert_encoding(strtr(trim($celula[4]), ",", "."), "UTF-8"), "?");
                $referencia = ltrim(mb_convert_encoding(trim($celula[5]), "UTF-8"), "?");
                $quantidade = ltrim(mb_convert_encoding(trim($celula[6]), "UTF-8"), "?");
                $uni = ltrim(mb_convert_encoding(trim($celula[7]), "UTF-8"), "?");
                $aplicacao = ltrim(mb_convert_encoding(trim($celula[8]), "UTF-8"), "?");

                $this->sql = "insert produto values(NULL, '" . $codigo . "', '" . $descricao . "', '" . $curva . "', " . $min . ", '" . $custo . "', '" . $referencia . "', '" . $quantidade . "', '" . $uni . "', '" . $aplicacao . "','0', '" . $id_quot . "')";

                if (!$this->db->query($this->sql)) {

                    fclose($arquivo);

                    return false;
                }
            }

            fclose($arquivo);

            return true;
        }

        return false;
    }

    public function selectLowestPrice($id_quot)
    {

        $this->db = \Config\Database::connect();

        $query   = $this->db->query('SELECT idproduto FROM produto WHERE cotacao_idcotacao = ' . $id_quot);

        $return_id_product = $query->getResultObject();

        foreach ($return_id_product as $product) {

            /**
             * Retorna o menor valor do produto.
             */

            $min = $this->db->query('SELECT DISTINCT MIN(valor) AS min FROM valores WHERE valor > 0 AND idproduto = ' . $product->idproduto . ' AND idcotacao = ' . $id_quot);

            if (!$min->getResult()) {
                continue;
            }

            /**
             * Retorna o id do usuário com menor valor.
             */

            $id_vencedor = $this->db->query('SELECT DISTINCT idusuario FROM valores WHERE valor = "' .
                $min->getResult()[0]->min .
                '" AND idproduto = ' .
                $product->idproduto .
                ' AND idcotacao = ' .
                $id_quot);

            if (!$id_vencedor->getResult()) {
                continue;
            }

            $update_product = $id_vencedor->getResult()[0]->idusuario;

            /** 
             *  Verifica se existe valores iguais.
             *  Caso verdadeiro, será inserido no campo vencedor da tabela produto o valor "-10".
             *  Esse valor será tratado para informar valores iguais no mesmo produto.
             *
             */

            $is_equal = $this->db->query('SELECT valor FROM valores WHERE valor = "' . $min->getResult()[0]->min . '" AND idusuario !=' . $id_vencedor->getResult()[0]->idusuario . ' AND idproduto = ' . $product->idproduto . ' AND idcotacao = ' . $id_quot);

            if ($is_equal->getResult()) {

                $update_product = -10;
            }

            $this->sql = 'UPDATE produto SET vencedor = "' . $update_product . '" WHERE idproduto = ' . $product->idproduto . ' AND cotacao_idcotacao = ' . $id_quot;

            if (!$this->db->query($this->sql)) {

                return false;
            }
        }

        return true;
    }
}
