<?php

namespace App\Controllers;

use App\Models\UserModel;
use CodeIgniter\Controller;

class Unknown extends Controller
{

    protected $helpers = ['cookie', 'form'];

    /**
     * Página de login.
     */

    public function login()
    {
        view('header', ['navbar' => view('navbar_unknown')]);

        return view('index', [

            'title_complement' => 'Login',

            'content_normal' => view('form_login'),

        ]);
    }

    public function signIn()
    {
        $login = $this->request->getPost('login');

        $password = md5($this->request->getPost('password'));

        $get_user = new UserModel();

        $user = $get_user->signIn($login, $password);

        if ($user) {

            $session_user = false;

            $status = $user[0]->tipo;

            switch ($status) {

                case 'a':
                    $session_user = 'Admin';
                    break;
                case 'e':
                    $session_user = 'Stockist';
                    break;
                case 'f':
                    $session_user = 'Supplier';
                    break;
                default:
                    $session_user = false;
                    break;
            }

            if (!$session_user) {

                return redirect()
                    ->to('login')
                    ->with('error', 'Tente novamente. Caso não consiga, informe ao administrador. {1}');
            }

            if (!$get_user->update($user[0]->idusuario, ['ultimo_acesso' => date('Y-m-d H:i:s')])) {

                return redirect()
                    ->to('login')
                    ->with('error', 'Tente novamente. Caso não consiga, informe ao administrador. {2}');
            }

            session()->set(
                [
                    'id_user' => $user[0]->idusuario,
                    'user' => $session_user,
                    'user_name' => $user[0]->nome,
                ]
            );

            return redirect($status);
        }

        return redirect()->to('login')->with('error', 'Login e senha não combinam.');
    }

    public function logout()
    {

        session()->destroy();

        return redirect('login');
    }
}
