<?php

namespace App\Controllers\Stockist;

use App\Controllers\Stockist\StockistMain;

class Store extends StockistMain
{

    public function __construct()
    {

        parent::__construct();
    }

    public function details($id_store)
    {

        $title_store = '';

        $result_orders = $this->store
            ->join('cotacao', 'cotacao.loja_idloja=loja.idloja', 'left')
            ->where([
                'loja.idloja' => $id_store,
                'cotacao.status' => 'e',
            ])->orderBy('idcotacao', 'desc')->findAll();

        if ($result_orders) {

            $title_store = 'Pedidos da loja ' .
                $result_orders[0]->nomeloja .
                ' | ' .
                $result_orders[0]->enderecoloja .
                ' | ' .
                $result_orders[0]->cnpjloja;
        }

        return view('index', [

            'title_complement' => $title_store,

            $this->CONTENT_NORMAL => view('stockist/store/details_store', [

                'title_store' => '',

                'orders' => $result_orders,

            ]),

        ]);
    }
}
