<?php

namespace App\Controllers\Stockist;

use App\Models\ParticipantsModel;
use App\Models\QuotModel;
use App\Models\ValuesModel;

class Order extends StockistMain
{

    private $order, $quot, $participants, $values;

    public function __construct()
    {
        parent::__construct();

        $this->values = new ValuesModel();

        $this->quot = new QuotModel();

        $this->participants = new ParticipantsModel();
    }

    public function ordersByQuot($id_quot, $id_store)
    {

        $total = 0;

        $col_ul_li = '';

        $status_quot = $this->quot->where(['idcotacao' => $id_quot])->findColumn('status');

        $participants = $this->participants->where(['cotacao' => $id_quot, 'concluido' => 's'])->select('usuario')->findAll();

        foreach ($participants as $participant) {

            $total_participant = 0;

            $orders = $this->values
                ->select('usuario.nome, produto.quantidade, valores.valor')
                ->join('usuario', 'usuario.idusuario=valores.idusuario', 'left')
                ->join('produto', 'produto.idproduto=valores.idproduto', 'left')
                ->join('cotacao', 'cotacao.idcotacao=produto.cotacao_idcotacao', 'left')
                ->where(
                    [
                        'valores.idcotacao' => $id_quot,
                        'valores.idusuario' => $participant->usuario,
                        'produto.vencedor' => $participant->usuario
                    ]
                )
                ->findAll();

            if ($orders) {

                $count_items = count($orders);

                $col_ul_li .= '<div class="col-lg mb-4">';

                $col_ul_li .= '<a href="' .
                    base_url(
                        'e/order/details_by_winner/' .
                            '/' .
                            $id_quot .
                            '/' .
                            $id_store .
                            '/' .
                            $participant->usuario .
                            $this->page
                    ) . '"><ul class="list-group">';

                $col_ul_li .= '<li class="list-group-item">' . $orders[0]->nome . '</li>';

                foreach ($orders as $order) {

                    $multiplication = ($order->valor * $order->quantidade);
                    $total_participant += $multiplication;
                }

                $col_ul_li .= '<li class="list-group-item">' . $count_items . ' itens</li>';

                $col_ul_li .= '<li class="list-group-item">R$ ' . number_format($total_participant, 2, ',', '.') . '</li>';

                $col_ul_li .= '</ul></a>';

                $col_ul_li .= '</div>';

                $total += $total_participant;
            }
        }


        return view(
            'index',
            [

                'title_complement' => 'Pedidos da loja ' . $this->nameStore($id_store) .
                    ' - <span data-bs-toggle="tooltip" title="Valor total dos pedidos">R$ ' .
                    number_format($total, 2, ',', '.') . '</span>',

                $this->CONTENT_NORMAL => view('stockist/order/details_order', [
                    'id_quot' => $id_quot,
                    'id_store' => $id_store,
                    'result' => $col_ul_li,
                    'status_quot' => $status_quot[0],
                ]),

            ]
        );
    }

    public function detailsByWinner($id_quot, $id_store, $id_winner)
    {

        $name_store = $this->store->where('idloja', $id_store)->findColumn('nomeloja');

        $order = $this->values
            ->select('usuario.nome, produto.*, valores.valor')
            ->join('usuario', 'usuario.idusuario=valores.idusuario', 'left')
            ->join('produto', 'produto.idproduto=valores.idproduto', 'left')
            ->join('cotacao', 'cotacao.idcotacao=produto.cotacao_idcotacao', 'left')
            ->where(
                [
                    'valores.idcotacao' => $id_quot,
                    'valores.idusuario' => $id_winner,
                    'produto.vencedor' => $id_winner
                ]
            )
            ->findAll();

        return view('index', [

            'title_complement' => 'Pedidos da loja ' . $this->nameStore($id_store) . ', para  ' . $order[0]->nome,

            $this->CONTENT_NORMAL => view('stockist/winner/details_winner', [

                'id_store' => $id_store,

                'id_quot' => $id_quot,

                'order' => $order,

            ]),

        ]);
    }

    public function details($id_quot, $id_store)
    {

        $data_store = $this->store->find($id_store);

        $this->order = $this->values
            ->select('usuario.nome, produto.*, valores.valor')
            ->join('usuario', 'usuario.idusuario=valores.idusuario')
            ->join('produto', 'produto.idproduto=valores.idproduto')
            ->join('cotacao', 'cotacao.idcotacao=produto.cotacao_idcotacao')
            ->where(
                [
                    'valores.idcotacao' => $id_quot,
                    'cotacao.status' => 'e',
                ]
            )
            ->findAll();

        return view(

            'index',

            [

                $this->CONTENT_NORMAL => view(

                    'stockist/order/details_order',

                    [
                        'title_order' => ($this->order) ? 'Pedido da loja ' .
                            $data_store->abreviacaoloja .
                            ' | ' .
                            $data_store->enderecoloja .
                            ' | ' .
                            $data_store->cnpjloja : 'Sem resultado...',

                        'orders' => $this->order,

                        'id_store' => $id_store,
                    ]
                ),
            ]
        );
    }
}
