<?php

namespace App\Controllers\Admin;

use App\Controllers\Admin\AdminMain;
use App\Models\ParticipantsModel;
use App\Models\ProductModel;
use App\Models\QuotModel;
use App\Models\UserModel;
use App\Models\ValuesModel;
use ZipArchive;

class Order extends AdminMain
{

    private $user, $participants, $products, $values, $quot;

    public function __construct()
    {
        parent::__construct();

        $this->user = new UserModel();

        $this->participants = new ParticipantsModel();

        $this->products = new ProductModel();

        $this->values = new ValuesModel();

        $this->quot = new QuotModel();
    }

    /**
     * Apresenta pedidios por cotação.
     */

    public function ordersByQuot($id_quot, $id_store)
    {

        $total = 0;

        $col_ul_li = '';

        $status_quot = $this->quot->where(['idcotacao' => $id_quot])->findColumn('status');

        $participants = $this->participants->where(['cotacao' => $id_quot, 'concluido' => 's'])->select('usuario')->findAll();

        foreach ($participants as $participant) {

            $total_participant = 0;

            $orders = $this->values
                ->select('usuario.nome, produto.quantidade, valores.valor')
                ->join('usuario', 'usuario.idusuario=valores.idusuario', 'left')
                ->join('produto', 'produto.idproduto=valores.idproduto', 'left')
                ->join('cotacao', 'cotacao.idcotacao=produto.cotacao_idcotacao', 'left')
                ->where(
                    [
                        'valores.idcotacao' => $id_quot,
                        'valores.idusuario' => $participant->usuario,
                        'produto.vencedor' => $participant->usuario
                    ]
                )
                ->findAll();

            if ($orders) {

                $count_items = count($orders);

                $col_ul_li .= '<div class="col-lg mb-4">';

                $col_ul_li .= '<a href="' .
                    base_url(
                        'a/order/details_by_winner/' .
                            '/' .
                            $id_quot .
                            '/' .
                            $id_store .
                            '/' .
                            $participant->usuario .
                            $this->page
                    ) . '"><ul class="list-group">';

                $col_ul_li .= '<li class="list-group-item">' . $orders[0]->nome . '</li>';

                foreach ($orders as $order) {

                    $multiplication = ($order->valor * $order->quantidade);
                    $total_participant += $multiplication;
                }

                $col_ul_li .= '<li class="list-group-item">' . $count_items . ' itens</li>';

                $col_ul_li .= '<li class="list-group-item">R$ ' . number_format($total_participant, 2, ',', '.') . '</li>';

                $col_ul_li .= '</ul></a>';

                $col_ul_li .= '</div>';

                $total += $total_participant;
            }
        }


        return view(
            'index',
            [

                'title_complement' => 'Pedidos da loja ' . $this->nameStore($id_store) .
                    ' - <span data-bs-toggle="tooltip" title="Valor total dos pedidos">R$ ' .
                    number_format($total, 2, ',', '.') . '</span>',

                $this->CONTENT_NORMAL => view('admin/order/details_order', [
                    'id_quot' => $id_quot,
                    'id_store' => $id_store,
                    'result' => $col_ul_li,
                    'status_quot' => $status_quot[0],
                ]),

            ]
        );
    }

    /**
     * Mostra detalhes dos pedidos por vencedor.
     */

    public function detailsByWinner($id_quot, $id_store, $id_winner)
    {

        $name_store = $this->store->where('idloja', $id_store)->findColumn('nomeloja');

        $order = $this->values
            ->select('usuario.nome, produto.*, valores.valor')
            ->join('usuario', 'usuario.idusuario=valores.idusuario', 'left')
            ->join('produto', 'produto.idproduto=valores.idproduto', 'left')
            ->join('cotacao', 'cotacao.idcotacao=produto.cotacao_idcotacao', 'left')
            ->where(
                [
                    'valores.idcotacao' => $id_quot,
                    'valores.idusuario' => $id_winner,
                    'produto.vencedor' => $id_winner
                ]
            )
            ->findAll();

        return view('index', [

            'title_complement' => 'Pedidos da loja ' . $this->nameStore($id_store) . ', para  ' . $order[0]->nome,

            $this->CONTENT_NORMAL => view('admin/winner/details_winner', [

                'id_store' => $id_store,

                'id_quot' => $id_quot,

                'order' => $order,

            ]),

        ]);
    }

    /**
     * Gera os arquivos.csv de todos os pedidos da cotação, e retorna em formato zip.
     */

    public function generateCsv($id_quot, $id_store)
    {

        function removeAcentos($string, $slug = false)
        {
            $string = strtolower($string);
            $ascii['a'] = range(224, 230);
            $ascii['e'] = range(232, 235);
            $ascii['i'] = range(236, 239);
            $ascii['o'] = array_merge(range(242, 246), array(240, 248));
            $ascii['u'] = range(249, 252);
            $ascii['b'] = array(223);
            $ascii['c'] = array(231);
            $ascii['d'] = array(208);
            $ascii['n'] = array(241);
            $ascii['y'] = array(253, 255);
            foreach ($ascii as $key => $item) {
                $acentos = '';
                foreach ($item as $codigo) $acentos .= chr($codigo);
                $troca[$key] = '/[' . $acentos . ']/i';
            }
            $string = preg_replace(array_values($troca), array_keys($troca), $string);
            if ($slug) {

                $string = preg_replace('/[^a-z0-9]/i', $slug, $string);

                $string = preg_replace('/' . $slug . '{2,}/i', $slug, $string);
                $string = trim($string, $slug);
            }
            return $string;
        }

        /**
         * Variaveis: 
         * $name_store: recebe o nome da loja tratado{caixa baixa e underscore}.
         * $zip_name: Nome do arquivo .zip,
         * $path: Caminho até a pasta temporária,
         * $full_path: Caminho e nome do arquivo .zip
         */

        $name_store = removeAcentos($this->nameStore($id_store), '_');

        $zip_name = 'cot_' . $id_quot . '_' . $name_store . '.zip';

        $path = FCPATH . 'public/csv_temp/';

        $full_path = $path . $zip_name;

        $zip = new ZipArchive;

        $zip->open($full_path, ZipArchive::CREATE);

        $participants = $this->participants->where(['cotacao' => $id_quot, 'concluido' => 's'])->select('usuario')->findAll();

        foreach ($participants as $participant) {

            $total_participant = 0;

            $order = $this->values
                ->select('usuario.nome, produto.*, valores.valor')
                ->join('usuario', 'usuario.idusuario=valores.idusuario')
                ->join('produto', 'produto.idproduto=valores.idproduto')
                ->join('cotacao', 'cotacao.idcotacao=produto.cotacao_idcotacao')
                ->where(
                    [
                        'valores.idcotacao' => $id_quot,
                        'valores.idusuario' => $participant->usuario,
                        'produto.vencedor' => $participant->usuario,
                        'cotacao.status' => 'e',
                    ]
                )
                ->findAll();

            if ($order) {

                $nome = removeAcentos($order[0]->nome, "-");

                $nome_arquivo = 'cot-' . $id_quot . '-' . $nome . '.csv';

                $output = fopen($path . $nome_arquivo, 'w');

                $headers = [$participant->usuario, ' CÓDIGO ', ' DESCRIÇÃO ', ' REFERÊNCIA ', ' VALOR ', ' QTD ', ' SUBTOTAL '];

                fputcsv($output, $headers, ';');

                foreach ($order as $valor) {

                    $vl = (number_format($valor->valor, 2, ',', '.'));

                    $sub = $valor->valor * $valor->quantidade;

                    $subTrata = number_format($sub, 2, ',', '.');

                    $linha = array('', $valor->codigo, $valor->descricao, $valor->referencia, $vl, $valor->quantidade, $subTrata);

                    fputcsv($output, $linha, ';');
                }

                fclose($output);

                $zip->addFile($path . $nome_arquivo, $nome_arquivo);
            }
        }

        $zip->close();

        if (!file_exists($full_path)) {

            return redirect()
                ->to('a/order/orders_by_quot/' . $id_quot . '/' . $id_store . $this->page)
                ->with('error', 'Ocorreu um erro ao fazer o download.');
        }

        header('Content-Type: application/zip');
        header('Content-Disposition: attachment; filename="' . $zip_name . '"');
        readfile($full_path);

        /**
         * Remove todos os arquivos temporários da pasta csv_temp.
         */

        $files_csv = glob($path . '*', GLOB_MARK);

        foreach ($files_csv as $csv) {

            unlink($csv);
        }
    }
}
