<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;

class AdminMain extends BaseController
{

    public function __construct()
    {
        parent::__construct();

        if (session()->get('user') != 'Admin') {
            session()->destroy();
        }
    }

    /**
     * Página inicial do administrador.
     */

    public function home(): string
    {

        return view('index', [

            'title_complement' => '',

            $this->CONTENT_NORMAL => view('admin/store/home_store', [

                'stores' => $this->store->findAll(),

            ])

        ]);
    }
}
